package w83b.ws.aa66;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;

import org.apache.commons.lang.StringEscapeUtils;

import w83b.webservices.aa66.AA66Notificaciones;
import w83b.webservices.aa66.NotificacionesWebServiceImplService_Impl;
import w83b.ws.W83bBaseWSInterface;
import w83b.ws.W83bWSInterfaceException;
import aa66.ejie.com.DestinatarioWs;
import aa66.ejie.com.EnvioWs;
import aa66.ejie.com.RemesaOutWs;
import aa66.ejie.com.RemesaWs;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

public class W83bAa66NotificacionesWS  extends W83bBaseWSInterface{
	
	private String sessiontoken;
	private boolean valitionEnabled=true;
	 public W83bAa66NotificacionesWS(String sessiontoken){
		 this.sessiontoken=sessiontoken;
	 }

	protected String getWebServiceURL() {
		return Q70ListenerUtils.getApplicationProperty("AA66_URL_WS");
	}
	
	
	/**
	 * Decide si la validacion de parmetros segun el XSD est habilitada
	 * @return true  si la validacion de parmetros segun el XSD est habilitada, false e.o.c.
	 */
	public boolean isValitionEnabled() {
		return this.valitionEnabled;
	}
	/**
	 * establece si la validacion de parmetros segun el XSD est habilitada
	 * @param valitionEnabled rue  si la validacion de parmetros segun el XSD est habilitada, false e.o.c.
	 */
	public void setValitionEnabled(boolean valitionEnabled) {
		this.valitionEnabled = valitionEnabled;
	}

	public RemesaOutWs cargaMasiva(RemesaWs remesa) throws W83bWSInterfaceException{
		AA66Notificaciones port;
		try {
			if(this.isValitionEnabled()){
				port = this.getPortAA66Notificaciones(this.sessiontoken, this.getWebServiceURL());
			}else{
				port=this.getPortAA66Notificaciones(this.sessiontoken, this.getWebServiceURL(), remesa);
				remesa=this.completeWhiteSpaces(remesa);
			}
		} catch (Exception e) {
			throw new W83bWSInterfaceException(this.getClass().getName(),"Error al obtener el port",e);
		}
		try {
			RemesaOutWs result =port.cargaMasiva(this.filtrarCaracteres(remesa));
			return result;
		} catch (RemoteException e) {
			throw new W83bWSInterfaceException(this.getClass().getName(),"Error al invocar el servicio 'cargaMasiva' ",e);
		}

	}
	
	private RemesaWs completeWhiteSpaces(RemesaWs remesa){
		RemesaWs remesaResult = new RemesaWs();
		if(remesa.getAplicacion()!=null){
			remesaResult.setAplicacion(remesa.getAplicacion());
		}
		if(remesa.getAplicacionDescEs()!=null){
			remesaResult.setAplicacionDescEs(remesa.getAplicacionDescEs());
		}
		if(remesa.getAplicacionDescEu()!=null){
		remesaResult.setAplicacionDescEu(remesa.getAplicacionDescEu());
		}
		if(remesa.getClaveCliente()!=null){
			remesaResult.setClaveCliente(remesa.getClaveCliente());
		}
		if(remesa.getDescripcionRemesa()!=null){
			remesaResult.setDescripcionRemesa(remesa.getDescripcionRemesa());
		}
		if(remesa.getEmail()!=null){
			remesaResult.setEmail(remesa.getEmail());
		}
		
		if(remesa.getListaEnvios()!=null){
			EnvioWs[] litaEnvios = new EnvioWs[remesa.getListaEnvios().length];
			EnvioWs envioActual = null;
			for(int i=0; i<remesa.getListaEnvios().length; i++ ){
				envioActual=new EnvioWs();
				if(remesa.getListaEnvios()[i].getDestinatario()!=null){
					envioActual.setDestinatario(remesa.getListaEnvios()[i].getDestinatario());
				}
				if(remesa.getListaEnvios()[i].getExpediente()!=null){
					envioActual.setExpediente(remesa.getListaEnvios()[i].getExpediente());
				}
				if(remesa.getListaEnvios()[i].getIdInterno()!=null){
					envioActual.setIdInterno(remesa.getListaEnvios()[i].getIdInterno());
				}
				String uidPuestoSolicitante=remesa.getListaEnvios()[i].getUidPuestoSolicitante();
				if(uidPuestoSolicitante.length()>10){
					uidPuestoSolicitante=uidPuestoSolicitante.substring(0,10);
				}else if(uidPuestoSolicitante.length()<7){
					StringBuffer uidPuestoSolicitanteCompleto= new StringBuffer(uidPuestoSolicitante);
					for(int j=0; j<=(7-uidPuestoSolicitante.length());j++){
						uidPuestoSolicitanteCompleto.append(" ");
					}
					uidPuestoSolicitante=uidPuestoSolicitanteCompleto.toString();
				}
				envioActual.setUidPuestoSolicitante(uidPuestoSolicitante);
				
				litaEnvios[i]=envioActual;
				
			}
			remesaResult.setListaEnvios(litaEnvios);
		
		}
		if(remesa.getMotivoEnvios()!=null){
			remesaResult.setMotivoEnvios(remesa.getMotivoEnvios());
		}
		remesaResult.setRecibirMail(remesa.getRecibirMail());
		if(remesa.getTelefonoTramitador()!=null){
			remesaResult.setTelefonoTramitador(remesa.getTelefonoTramitador());
		}
		remesaResult.setTipoRemesa(remesa.getTipoRemesa());
		String uidPuestoTramitador=remesa.getUidPuestoTramitador();
		if(uidPuestoTramitador.length()>10){
			uidPuestoTramitador=uidPuestoTramitador.substring(0,10);
		}else if(uidPuestoTramitador.length()<7){
			StringBuffer uidPuestoTramitadorCompleto= new StringBuffer(uidPuestoTramitador);
			for(int j=0; j<=(7-uidPuestoTramitador.length());j++){
				uidPuestoTramitadorCompleto.append(" ");
			}
			uidPuestoTramitador=uidPuestoTramitadorCompleto.toString();
		}
		remesaResult.setUidPuestoTramitador(uidPuestoTramitador);
		return remesaResult;
	}
	
	private  AA66Notificaciones getPortAA66Notificaciones(String sessionToken,String url) throws Exception{
		
		NotificacionesWebServiceImplService_Impl aa66 = new NotificacionesWebServiceImplService_Impl(url);
		

		Iterator i =  aa66.getPorts();
		HandlerRegistry registry = aa66.getHandlerRegistry();
		
		List handlerList = new ArrayList();
        Map map = new HashMap();
        map.put("sessionToken", sessionToken);
        handlerList.add( new HandlerInfo( W83bAa66NotificacionesTokenHandler.class, map, null ) );
        
        Object myPort  =i.next();
   
        
	     /*
	      * dcarranz: invocar por reflexion para evitar incompatibilidad de tipos entre diferentes JAR
	      * */
        Method setHandlerChain =registry.getClass().getMethod("setHandlerChain", new Class[]{myPort.getClass(),java.util.List.class});
        setHandlerChain.invoke(registry, new Object[]{myPort,handlerList});
      
  
        
        
        AA66Notificaciones notificaciones = aa66.getAA66Notificaciones();

		return notificaciones;
	}
	
	private  AA66Notificaciones getPortAA66Notificaciones(String sessionToken,String url,RemesaWs remesaWs) throws Exception{
		
		NotificacionesWebServiceImplService_Impl aa66 = new NotificacionesWebServiceImplService_Impl(url);
		

		Iterator i =  aa66.getPorts();
		HandlerRegistry registry = aa66.getHandlerRegistry();
		
		List handlerList = new ArrayList();
        Map map = new HashMap();
        map.put("sessionToken", sessionToken);
        map.put("remesaWs", remesaWs);
        handlerList.add( new HandlerInfo( W83bAa66NotificacionesTokenHandler.class, map, null ) );
        
        Object myPort  =i.next();
   
        
	     /*
	      * dcarranz: invocar por reflexion para evitar incompatibilidad de tipos entre diferentes JAR
	      * */
        Method setHandlerChain =registry.getClass().getMethod("setHandlerChain", new Class[]{myPort.getClass(),java.util.List.class});
        setHandlerChain.invoke(registry, new Object[]{myPort,handlerList});
      
        AA66Notificaciones notificaciones = aa66.getAA66Notificaciones();

		return notificaciones;
	}
	
	/**
	 * Filtra lso caracteres que puedan dar errores al generar el xml
	 * @param remesa RemesaWs
	 * @return RemesaWs
	 */
	private RemesaWs filtrarCaracteres(RemesaWs remesa){
		RemesaWs remesaFiltrada = new RemesaWs();
		remesaFiltrada.setAplicacion(remesa.getAplicacion());
		remesaFiltrada.setAplicacionDescEs(StringEscapeUtils.escapeXml(remesa.getAplicacionDescEs()));
		remesaFiltrada.setAplicacionDescEu(StringEscapeUtils.escapeXml(remesa.getAplicacionDescEu()));
		if(remesa.getEmail()!=null){
			remesaFiltrada.setEmail(remesa.getEmail());
		}

		EnvioWs[] enviosFitrados = new EnvioWs[remesa.getListaEnvios().length];
		EnvioWs envioFitrado=null;
		DestinatarioWs destinatarioFiltrado = null;
		for(int i=0; i<remesa.getListaEnvios().length; i++){
			envioFitrado=new EnvioWs();

			destinatarioFiltrado=new DestinatarioWs();
			if(remesa.getListaEnvios()[i].getDestinatario().getCodigoPostal()!=null){
				destinatarioFiltrado.setCodigoPostal(remesa.getListaEnvios()[i].getDestinatario().getCodigoPostal());
			}
			if(remesa.getListaEnvios()[i].getDestinatario().getDireccion()!=null){
				destinatarioFiltrado.setDireccion(StringEscapeUtils.escapeXml(remesa.getListaEnvios()[i].getDestinatario().getDireccion().replaceAll("\"", "").replaceAll("&", "").replaceAll("", "").replaceAll("", "").replaceAll("", "n").replaceAll("", "N").replaceAll("", "A").replaceAll("", "a").replaceAll("", "E").replaceAll("", "e").replaceAll("", "I").replaceAll("", "i").replaceAll("", "O").replaceAll("", "o").replaceAll("", "U").replaceAll("", "u")));
			}
			if(remesa.getListaEnvios()[i].getDestinatario().getInstitucion()!=null){
				destinatarioFiltrado.setInstitucion(StringEscapeUtils.escapeXml(remesa.getListaEnvios()[i].getDestinatario().getInstitucion().replaceAll("\"", "").replaceAll("&", "").replaceAll("", "").replaceAll("", "").replaceAll("", "n").replaceAll("", "N").replaceAll("", "A").replaceAll("", "a").replaceAll("", "E").replaceAll("", "e").replaceAll("", "I").replaceAll("", "i").replaceAll("", "O").replaceAll("", "o").replaceAll("", "U").replaceAll("", "u")));
			}
			if(remesa.getListaEnvios()[i].getDestinatario().getNombreApellidos()!=null){
				destinatarioFiltrado.setNombreApellidos(StringEscapeUtils.escapeXml(remesa.getListaEnvios()[i].getDestinatario().getNombreApellidos().replaceAll("\"", "").replaceAll("&", "").replaceAll("", "").replaceAll("", "").replaceAll("", "n").replaceAll("", "N").replaceAll("", "A").replaceAll("", "a").replaceAll("", "E").replaceAll("", "e").replaceAll("", "I").replaceAll("", "i").replaceAll("", "O").replaceAll("", "o").replaceAll("", "U").replaceAll("", "u")));
			}
			if(remesa.getListaEnvios()[i].getDestinatario().getLocalidad()!=null){
				destinatarioFiltrado.setLocalidad(StringEscapeUtils.escapeXml(remesa.getListaEnvios()[i].getDestinatario().getLocalidad()));
			}
			if(remesa.getListaEnvios()[i].getDestinatario().getMunicipio()!=null){
				destinatarioFiltrado.setMunicipio(StringEscapeUtils.escapeXml(remesa.getListaEnvios()[i].getDestinatario().getMunicipio()));
			}
			if(remesa.getListaEnvios()[i].getDestinatario().getProvincia()!=null){
				destinatarioFiltrado.setProvincia(StringEscapeUtils.escapeXml(remesa.getListaEnvios()[i].getDestinatario().getProvincia()));
			}
			
			envioFitrado.setDestinatario(destinatarioFiltrado);
			envioFitrado.setExpediente(remesa.getListaEnvios()[i].getExpediente());
			envioFitrado.setIdInterno(remesa.getListaEnvios()[i].getIdInterno());
			envioFitrado.setUidPuestoSolicitante(remesa.getListaEnvios()[i].getUidPuestoSolicitante());
			enviosFitrados[i]=envioFitrado;
		}
		remesaFiltrada.setListaEnvios(enviosFitrados);
		if(remesa.getMotivoEnvios()!=null){
			remesaFiltrada.setMotivoEnvios(remesa.getMotivoEnvios());		
		}
		remesaFiltrada.setRecibirMail(remesa.getRecibirMail());
		remesaFiltrada.setTelefonoTramitador(remesa.getTelefonoTramitador());
		remesaFiltrada.setTipoRemesa(remesa.getTipoRemesa());
		remesaFiltrada.setUidPuestoTramitador(remesa.getUidPuestoTramitador());
		return remesaFiltrada;
	}

}
